package com.wissamfawaz;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Main {
    public static void main(String[] args) {
        String[] suits = { "Spades", "Clubs", "Hearts", "Diamonds" };
        List<String> suitsAsLL = new LinkedList<>(Arrays.asList(suits));
        System.out.println("Original list: " + suitsAsLL);
        System.out.println("Min: " + Collections.min(suitsAsLL));
        System.out.println("Max: " + Collections.max(suitsAsLL));

        Collections.sort(suitsAsLL);
        System.out.println("List sorted in an ascending order: " + suitsAsLL);
        Collections.sort(suitsAsLL, Collections.reverseOrder());
        System.out.println("List sorted in a descending order: " + suitsAsLL);
        Collections.shuffle(suitsAsLL);
        System.out.println("Shuffled list: " + suitsAsLL);

        String[] copyArray = new String[suits.length];
        List<String> copyList = new LinkedList<>(Arrays.asList(copyArray));

        Collections.copy(copyList, suitsAsLL);
        System.out.println("Disjoint? " + Collections.disjoint(suitsAsLL, copyList));
        copyList.addAll(suitsAsLL);
        System.out.println("Frequency of diamonds: " + Collections.frequency(copyList, "Diamonds"));

    }

}
